import os
from Log import LOG
from Gui import GUI
import ObjectItem
import requests
from Options import options
import threading
from MonstersReference import monsters_ref
from i18n import i18n_fr
from Server import server
import json

EQUIPMENTS = [
    81,
    82,
    23,
    22,
    21,
    19,
    20,
    17,
    16,
    11,
    10,
    9,
    8,
    7,
    6,
    5,
    4,
    3,
    2,
    1
]

MOUNT = [97, 196, 207]

SOULSTONE = 85

class AuctionHouseItem():
    def __init__(self):
        self.message = ObjectItem.ExchangeTypesItemsExchangerDescriptionForUser()


class AuctionHouse():
    def __init__(self, player, server):
        self.player = player
        self.server = server
        self.ah_items = []
        self.ames = None

    def add_item(self, window_name):
        current = AuctionHouseItem().message
        self.ames = {}
        for item in current.items:
            if item.object_type in EQUIPMENTS:
                self.equipment_handler(item)
            elif item.object_type in MOUNT:
                self.mount_handler(item)
            elif item.object_type == SOULSTONE:
                self.soulstone_handler(item)
            else:
                self.send_item_to_server(item)
        if self.ames != {}:
            self.server.send_to_server(self.ames, "archmonsters/register_prices")
        return

    def send_item_to_server(self, values):
        data = {
            'object_gid': values.object_gid,
            'object_name': values.name,
            'pp1': values.prices[0],
            'pp10': values.prices[1],
            'pp100': values.prices[2],
        }
        self.server.send_to_server(data, "items/register_prices/")

    def mount_handler(self, item):
        for eff in item.effects:
            if eff.action_id == 995:
                for capa in eff.capacities:
                    if capa == 10:
                        if item.prices[0] < 1000000:
                            LOG.info("{} - Prix: {:,.2f}".format(item.name, item.prices[0]))

    def equipment_handler(self, item):
        item = item.value
        LOG.info(f"{item.name}:  {item.prices[0]:,.2f} ({item.weight}/{item.max_weight})")

    def soulstone_handler(self, item):
        for effect in item.effects:
            if hasattr(effect, 'dice_const'):
                for m in monsters_ref.data:
                    if m["id"] == effect.dice_const:
                        if m['isMiniBoss'] == True:
                            monster_name = i18n_fr.get_name(str(m['nameId']))
                            if str(m['id']) in self.ames and item.prices[0] < self.ames[str(m['id'])]['price']:
                                self.ames[str(m['id'])] = {'name': monster_name, 'price': item.prices[0]}
                            elif str(m['id']) not in self.ames:
                                self.ames[str(m['id'])] = {'name': monster_name, 'price': item.prices[0]}
