from Reader import reader
from EffectsReference import effects_reference
from SpellReference import spells_reference
from SpellLevelReference import spell_levels_reference
from i18n import i18n_fr
PA = 1
PM = 2
PO = 3
OTHERS = 4

class Effect():
    def __init__(self):
        self.source_id = 0
        self.action_id = 0
        self.delta = 0
        self.uid = reader.readVarUhInt()
        self.target_id = reader.readDouble()
        self.turn_duration = reader.readShort()
        self.dispelable = reader.readByte()
        self.spell_id = reader.readVarUhShort()
        self.effect_id = reader.readVarUhInt()
        self.parent_boost_uid = reader.readVarUhInt()
        self.effect_type = None
        self.max_stack = 0
        self.delay = 0
        self.visible = False
        self.negative = False
        self.operator = ""
        self.add_various_stuff()

    def add_various_stuff(self):
        self.name = i18n_fr.get_name(spells_reference.get_spell_by_id(self.spell_id)['nameId'])
        spell_level, effect = spell_levels_reference.get_spell_level_and_effect_by_effect_uid(self.effect_id)
        if spell_level == None or effect == None:
            return
        effect_type = effects_reference.get_effect_by_id(effect['effectId'])
        self.max_stack = spell_level['maxStack']
        self.visible = effect['visibleInBuffUi']
        self.delta = effect['diceNum']
        self.delay = effect['delay']
        self.effect_type = effect_type['characteristic']
        self.operator = effect_type['operator'] if effect_type['operator'] is not None else ""
        if effect_type['operator'] == '-':
            self.negative = True
    
    def __str__(self):
        e = self
        val = "PA" if e.effect_type == 1 else "PM" if e.effect_type == 23 else e.effect_type
        delay = f"in {e.delay} turns" if e.delay > 0 else ""
        turns = f"(infinite)" if e.turn_duration == -1000 and e.delay <= 0 else f"{e.turn_duration} turns" if e.delay <= 0 else ""
        return f"({e.uid}){e.effect_id} {e.name} ({e.spell_id}) {e.operator}{e.delta} {val} {delay}{turns}"

class FightTemporaryBoostEffect(Effect):
    def __init__(self):
        super().__init__()
        self.delta = reader.readInt()
        return

class FightTemporarySpellBoostEffect(FightTemporaryBoostEffect):
    def __init__(self):
        super().__init__()
        self.boosted_spell = reader.readVarUhShort()

class FightTemporaryBoostStateEffect(FightTemporaryBoostEffect):
    def __init__(self):
        super().__init__()
        self.state_id = reader.readShort()
        return

class FightTemporarySpellImmunityEffect(Effect):
    def __init__(self):
        super().__init__()
        self.immune_spell_id = reader.readInt()
        return

class FightTriggeredEffect(Effect):
    def __init__(self):
        super().__init__()
        self.param1 = reader.readInt()
        self.param2 = reader.readInt()
        self.param3 = reader.readInt()
        self.delay = reader.readShort()
        return

class CombatEffect():
    def __init__(self):
        self.action_id = reader.readVarUhShort()
        self.source_id = reader.readDouble()
        typev = reader.readType()
        if typev == "FightTemporaryBoostEffect;":
            self.effect = FightTemporaryBoostEffect()
        elif typev == "FightTemporarySpellBoostEffect;":
            self.effect = FightTemporarySpellBoostEffect()
        elif typev == "FightTemporaryBoostStateEffect;":
            self.effect = FightTemporaryBoostStateEffect()
        elif typev == "FightTriggeredEffect;":
            self.effect = FightTriggeredEffect()
        elif typev == "FightTemporarySpellImmunityEffect;":
            self.effect = FightTemporarySpellImmunityEffect()
        else:
            LOG.error("Unhandled type", typev, "for CombatEffect")
            return
        self.effect.source_id = self.source_id
        self.effect.action_id = self.action_id
