from Reader import reader, types, status
from Log import LOG
from Gui import GUI
import Actor
class MapObstacle():
    def __init__(self):
        self.cell_id = reader.readVarUhShort()
        self.state = reader.readByte()

class StatedElement():
    def __init__(self):
        self.element_id = reader.readInt()
        self.element_cell_id = reader.readVarUhShort()
        self.element_state = reader.readVarUhInt()
        self.on_map = reader.readBoolean()

class InteractiveElementSkill():
    def __init__(self):
        self.skill_id = reader.readVarUhInt()
        self.skill_instance_id = reader.readInt()
        return

class InteractiveElementNamedSkill(InteractiveElementSkill):
    def __init__(self):
        super().__init__()
        self.name_id = reader.readVarUhInt()
        return

class InteractiveElement():
    def __init__(self):
        self.last_timer = -1
        self.element_id = reader.readInt()
        self.element_type_id = reader.readInt()
        length = reader.readUnsignedShort()
        self.enabled_skills = []
        for i in range(0, length):
            typev = reader.readType()
            if typev == "InteractiveElementSkill;":
                self.enabled_skills.append(InteractiveElementSkill())
            elif typev == "InteractiveElementNamedSkill;":
                self.enabled_skills.append(InteractiveElementNamedSkill())
            else:
                LOG.error(f"Unhandled type {typev} for InteractiveElementSkill/Enabled")
        length = reader.readUnsignedShort()
        self.disabled_skills = []
        for i in range(0, length):
            typev = reader.readType()
            if typev == "InteractiveElementSkill;":
                self.disabled_skills.append(InteractiveElementSkill())
            elif typev == "InteractiveElementNamedSkill;":
                self.disabled_skills.append(InteractiveElementNamedSkill())
            else:
                LOG.error(f"Unhandled type {typev} for InteractiveElementSkill/Disabled")
        self.on_map = reader.readBoolean()
        return

class InteractiveElementWithAgeBonus(InteractiveElement):
    def __init__(self):
        super().__init__()
        self.age_bonus = reader.readShort()
        return

class InteractiveElementUpdated():
    def __init__(self):
        self.element = InteractiveElement()