from Reader import reader, types, status
from Log import LOG
from Gui import GUI
from i18n import i18n_fr
from pprint import pprint, pformat
from ObjectItem import obj_ref
import Guild

class FightResultAdditionalData():
    def __init__(self):
        pass

    def hash(self):
        return 0

class FightResultPvpData(FightResultAdditionalData):
    def __init__(self):
        super().__init__()
        self.grade = reader.readUnsignedByte()
        self.min_honor_for_grade = reader.readVarUhShort()
        self.max_honor_for_grade = reader.readVarUhShort()
        self.honor = reader.readVarUhShort()
        self.honor_delta = reader.readVarShort()

class FightResultExperienceData():
    def __init__(self):
        super().__init__()
        boxed_infos = reader.readByte()
        self.experience = reader.readVarUhLong()
        self.show_experience = boxed_infos & 1 == 1
        self.experience_level_floor = reader.readVarUhLong()
        self.show_experience_level_floor = boxed_infos & 2 == 1
        self.experience_next_level_floor = reader.readVarUhLong()
        self.show_experience_next_level_floor = boxed_infos & 3 == 1
        self.experience_fight_delta = reader.readVarUhLong()
        self.show_experience_fight_delta = boxed_infos & 4 == 1
        self.experience_for_guild = reader.readVarUhLong()
        self.show_experience_for_guild = boxed_infos & 5 == 1
        self.experience_for_mount = reader.readVarUhLong()
        self.show_experience_for_mount = boxed_infos & 6 == 1
        self.is_incarnation_experience = boxed_infos & 7 == 1
        self.reroll_experience_mul = reader.readVarUhLong()

    def hash(self):
        return self.experience + self.experience_fight_delta

class FightLoot():
    def __init__(self):
        self.objects = []
        for _ in range(0, int(reader.readUnsignedShort() / 2)):
            obj = reader.readVarUhInt()
            self.objects.append({"name": obj_ref.get_object_name(obj), "id": obj, "quantity": reader.readVarUhInt()})
        self.kamas = reader.readVarUhLong()

    def to_list(self):
        l = []
        for item in self.objects:
            l.append(item['id'])
            l.append(item['quantity'])
        return l

class FightResultListEntry():
    def __init__(self):
        self.outcome = reader.readVarUhShort()
        self.wave = reader.readByte()
        self.rewards = FightLoot()
        self.damage = 0

    def hash(self):
        return 0

    def winner(self):
        return 0 if self.outcome == 2 else 1 if self.outcome == 0 else -1

class FightResultFighterListEntry(FightResultListEntry):
    def __init__(self):
        super().__init__()
        self.id = reader.readDouble()
        self.name = None
        self.gid = -1
        self.alive = reader.readBoolean()
        self.is_player = False

    def hash(self):
        return self.id

class FightResultTaxCollectorListEntry(FightResultFighterListEntry):
    def __init__(self):
        super().__init__()
        self.level = reader.readUnsignedByte()
        self.guild_infos = Guild.BasicGuildInformations()
        self.guild_xp = reader.readInt()

class FightResultPlayerListEntry(FightResultFighterListEntry):
    def __init__(self):
        super().__init__()
        self.level = reader.readVarUhShort()
        self.additional = []
        self.is_player = True
        length = reader.readUnsignedShort()
        for _ in range(0, length):
            typev = reader.readType()
            if typev == "FightResultAdditionalData;":
                self.additional.append(FightResultAdditionalData())
            elif typev == "FightResultPvpData;":
                self.additional.append(FightResultPvpData())
            elif typev == "FightResultExperienceData;":
                self.additional.append(FightResultExperienceData())
            else:
                LOG.error(f"Unhandled type {typev} for FightResultPlayerListEntry")

    def hash(self):
        hashed = self.id
        for add in self.additional:
            hashed += add.hash()
        return hashed

class FightResultMutantListEntry(FightResultFighterListEntry):
    def __init__(self):
        super().__init__()
        self.level = reader.readVarUhShort()
