from Reader import reader, types, status
from Log import LOG
from Gui import GUI
import requests
import Guild
import os
import json
from pickler import decompress_pickle
from Options import options
from Server import server
from i18n import i18n_fr

class HouseReference():
    def __init__(self):
        self.data = decompress_pickle(f'{os.path.dirname(__file__)}/data/Houses.pbz2')
    def find_by_id(self, idv):
        idv = int(idv)
        for item in self.data:
            if idv == int(item['typeId']):
                return item
        return None

house_ref = HouseReference()

class HouseInformations():
    def __init__(self):
        self.house_id = reader.readVarUhInt()
        self.model_id = reader.readVarUhShort()
        self.model = house_ref.find_by_id(self.model_id)
        self.name = i18n_fr.get_name(self.model['nameId'])

class HouseInstanceInformations():
    def __init__(self):
        self.box_infos = reader.readByte()
        self.is_second_hand = False if self.box_infos & 1 == 0 else True
        self.is_locked = False if self.box_infos & 2 == 0 else True
        self.is_sale_locked = False if self.box_infos & 4 == 0 else True
        self.instance_id = reader.readInt()
        self.owner = reader.readString()
        self.price = reader.readVarLong()

class AccountHouseInformations(HouseInformations):
    def __init__(self):
        super().__init__()
        typev = reader.readType()
        if typev == "HouseInstanceInformations;":
            self.infos = HouseInstanceInformations()
        else:
            LOG.error(f"Unhandled type: {typev} for AccountHouseInformations")
        self.world_x = reader.readShort()
        self.world_y = reader.readShort()
        self.map_id = reader.readDouble()
        self.sub_area_id = reader.readVarUhShort()


class HouseInformationsInside(HouseInformations):
    def __init__(self):
        super().__init__()
        typev = reader.readUnsignedShort()
        if typev == "HouseInstanceInformations;":
            self.infos = HouseInstanceInformations()
        else:
            LOG.error(f"Unhandled type: {typev} for HouseInformationsInside")
        self.world_x = reader.readShort()
        self.world_y = reader.readShort()

class HouseOnMapInformations(HouseInformations):
    def __init__(self):
        super().__init__()
        self.doors_on_map_len = reader.readUnsignedShort()
        self.doors_on_map = []
        for i in range(0, self.doors_on_map_len):
            self.doors_on_map.append(reader.readInt())
        self.house_instances_len = reader.readUnsignedShort()
        self.house_instances = []
        for i in range(0, self.house_instances_len):
            self.house_instances.append(HouseInstanceInformations())

class HouseInformationsForGuild(HouseInformations):
    def __init__(self):
        super().__init__()
        self.instance_id = reader.readInt()
        self.second_hand = reader.readBoolean()
        self.owner_name = reader.readString()
        self.world_X = reader.readShort()
        self.world_Y = reader.readShort()
        self.map_id = reader.readDouble()
        self.sub_area_id = reader.readVarUhShort()

class HouseProperties():
    def __init__(self):
        self.house_id = reader.readVarUhInt()
        self.doors_on_map = []
        self.doors_on_map_len = reader.readUnsignedShort()
        for i in range(0, self.doors_on_map_len):
            self.doors_on_map.append(reader.readInt())
        typev = reader.readType()
        if typev == "HouseInstanceInformations;":
            self.properties = HouseInstanceInformations()
        elif typev == "HouseGuildedInformations;":
            self.properties = HouseGuildedInformations()
        else:
            LOG.error(f"Unhandled type: {typev} for HouseProperties")

class HouseGuildedInformations(HouseInstanceInformations):
    def __init__(self):
        super().__init__()
        self.guild = Guild.GuildInformations()
        return
