from Reader import reader, types, status
from Log import LOG
from Gui import GUI
import Guild
import Alliance
import Actor

class HumanOption():
    def __init__(self):
        return

class HumanOptionObjectUse(HumanOption):
    def __init__(self):
        super().__init__()
        self.delay_type_id = reader.readByte()
        self.delay_end_time = reader.readDouble()
        self.object_gid = reader.readVarUhShort()
        return

class HumanOptionAlliance(HumanOption):
    def __init__(self):
        super().__init__()
        self.alliance_informations = Alliance.AllianceInformations()
        self.aggressable = reader.readByte()
        return

class HumanOptionGuild(HumanOption):
    def __init__(self):
        super().__init__()
        self.guild = Guild.GuildInformations()
        return

class HumanOptionTitle(HumanOption):
    def __init__(self):
        super().__init__()
        self.title = reader.readVarUhShort()
        self.param = reader.readString()
        return

class HumanOptionEmote(HumanOption):
    def __init__(self):
        super().__init__()
        self.emote_id = reader.readByte()
        self.emote_start_time = reader.readDouble()
        return

class HumanOptionOrnament(HumanOption):
    def __init__(self):
        super().__init__()
        self.ornament = reader.readVarUhShort()
        self.level = reader.readVarUhShort()
        self.league_id = reader.readVarShort()
        self.ladder_pos = reader.readInt()

class HumanOptionSkillUse(HumanOption):
    def __init__(self):
        super().__init__()
        self.element_id = reader.readVarUhInt()
        self.skill_id = reader.readVarUhShort()
        self.skill_end_time = reader.readDouble()

class HumanOptionFollowers(HumanOption):
    def __init__(self):
        super().__init__()
        self.followers_len = reader.readUnsignedShort()
        self.followers = []
        for i in range(0, self.followers_len):
            self.followers.append(Actor.IndexedEntityLook())

class HumanInformations():
    def __init__(self):
        self.restrictions = Actor.ActorRestrictionsInformations()
        self.sex = reader.readBoolean()
        self.options_len = reader.readUnsignedShort()
        self.options = []
        for i in range(0, self.options_len):
            typev = reader.readType()
            if typev == "HumanOption;":
                self.options.append(HumanOption())
            elif typev == "HumanOptionObjectUse;":
                self.options.append(HumanOptionObjectUse())
            elif typev == "HumanOptionAlliance;":
                self.options.append(HumanOptionAlliance())
            elif typev == "HumanOptionGuild;":
                self.options.append(HumanOptionGuild())
            elif typev == "HumanOptionOrnament;":
                self.options.append(HumanOptionOrnament())
            elif typev == "HumanOptionEmote;":
                self.options.append(HumanOptionEmote())
            elif typev == "HumanOptionTitle;":
                self.options.append(HumanOptionTitle())
            elif typev == "HumanOptionSkillUse;":
                self.options.append(HumanOptionSkillUse())
            elif typev == "HumanOptionFollowers;":
                self.options.append(HumanOptionFollowers())
            else:
                LOG.error(f"Unhandled type {typev} for HumanInformations")
