import os
import utils
import sys
import json
import datetime
from Gui import GUI

INFO = 0
DEBUG = 2
DUMP_ALL = 3
DUMP_HEX = 4

class Log():
    level = 0
    def __init__(self):
        self.author = None
        self.multi = True
        self.window = None


    def set_author(self, name):
        self.author = name

    def set_multi(self, val):
        if val.lower() == 'on':
            self.multi = True
        elif val.lower() == 'off':
            self.multi = False
        else:
            print ("Unrecognized arg (expected on/off)")
            return
        print ("Ok")

    def welcome(self, version):
        print ("   _,.----.  ,--.-,,-,--,  Welcome on .=-.-.  ,-,--.     _ __      ,-,--.  ")
        print (" .' .' -   \\/==/  /|=|  | .-.,.---.  /==/_ /,-.'-  _\\ .-`.' ,`.  ,-.'-  _\\ ")
        print ("/==/  ,  ,-'|==|_ ||=|, |/==/  `   \\|==|, |/==/_ ,_.'/==/, -   \\/==/_ ,_.' ")
        print ("|==|-   |  .|==| ,|/=| _|==|-, .=., |==|  |\\==\\  \\  |==| _ .=. |\\==\\  \\    ")
        print ("|==|_   `-' \\==|- `-' _ |==|   '='  /==|- | \\==\\ -\\ |==| , '=',| \\==\\ -\\   ")
        print ("|==|   _  , |==|  _     |==|- ,   .'|==| ,| _\\==\\ ,\\|==|-  '..'  _\\==\\ ,\\  ")
        print ("\\==\\.       /==|   .-. ,\\==|_  . ,'.|==|- |/==/\\/ _ |==|,  |    /==/\\/ _ | ")
        print (" `-.`.___.-'/==/, //=/  /==/  /\\ ,  )==/. /\\==\\ - , /==/ - |    \\==\\ - , / ")
        print (f"            `--`-' `-`--`--`-`--`--'`--`-`  `--`---'`--`---'v{version:<4}`--`---'")

    def set_verbosity(self, vb=0):
        Log.level = int(vb)

    def clear(self, vb):
        if vb >= 0 and vb != self.level:
            return
        if os.name == 'nt':
            _ = os.system('cls')
        else:
            _ = os.system('clear')

    def info(self, string, endv="\n"):
        if Log.level >= INFO:
            print (f"[{datetime.datetime.now().strftime('%H:%M:%S')}] {str(string)}")#, end=endv)

    def error(self, string, endv="\n"):
        print (f"[{datetime.datetime.now().strftime('%H:%M:%S')}] {str(string)}")#, end=endv)

    def debug(self, string, endv="\n"):
        if Log.level >= DEBUG:
            print (f"[{datetime.datetime.now().strftime('%H:%M:%S')}] {str(string)}", end=endv)

    def dump(self, string, endv="\n"):
        if Log.level >= DUMP_ALL:
            print (f"[{datetime.datetime.now().strftime('%H:%M:%S')}] {str(string)}", end=endv)

def obj_to_string(obj, extra='    '):
    print (str(obj.__class__) + '\n' + '\n'.join(
        (extra + (str(item) + ' = ' +
                (obj_to_string(obj.__dict__[item], extra + '    ') if hasattr(obj.__dict__[item], '__dict__') else str(
                    obj.__dict__[item])))
        for item in obj.__dict__)))

LOG = Log()
