import os
import json
from pickler import decompress_pickle


class MapReference():
    def __init__(self):
        self.data = decompress_pickle(f'{os.path.dirname(__file__)}/data/MapPositions.pbz2')
    def get_map_by_id(self, idv):
        idv = int(idv)
        for item in self.data:
            if idv == item['id']:
                return item
        return None

map_ref = MapReference()

class SubAreaReference():
    def __init__(self):
        self.data = decompress_pickle(f'{os.path.dirname(__file__)}/data/SubAreas.pbz2')
    def get_map_by_id(self, idv):
        idv = int(idv)
        for item in self.data:
            if idv == item['id']:
                return item
        return None

subarea_ref = SubAreaReference()

class AreaReference():
    def __init__(self):
        self.data = decompress_pickle(f'{os.path.dirname(__file__)}/data/Areas.pbz2')
    def get_map_by_id(self, idv):
        idv = int(idv)
        for item in self.data:
            if idv == item['id']:
                return item
        return None

area_ref = AreaReference()


class SuperAreaReference():
    def __init__(self):
        self.data = decompress_pickle(f'{os.path.dirname(__file__)}/data/SuperAreas.pbz2')
    def get_map_by_id(self, idv):
        idv = int(idv)
        for item in self.data:
            if idv == item['id']:
                return item
        return None

superarea_ref = SuperAreaReference()