from Reader import reader, types, status
from Log import LOG
from MonstersReference import monsters_ref
from i18n import i18n_fr
from Gui import GUI
import Actor
import os
import json


class MonsterInGroupLightInformations():
    def __init__(self):
        self.creature_generic_id = reader.readInt()
        for i in monsters_ref.data:
            if i["id"] == self.creature_generic_id:
                self.name = i18n_fr.get_name(str(i['nameId']))
        self.grade = reader.readByte()
        self.level = reader.readShort()

class AlternativeMonstersInGroupLightInformations():
    def __init__(self):
        self.player_count = reader.readInt()
        self.monsters_len = reader.readUnsignedShort()
        self.monsters = []
        for i in range(0, self.monsters_len):
            self.monsters.append(MonsterInGroupLightInformations())

class MonsterInGroupInformations(MonsterInGroupLightInformations):
    def __init__(self):
        super().__init__()
        self.look = Actor.EntityLook()

class GroupMonsterStaticInformations():
    def __init__(self):
        self.main_monster = MonsterInGroupLightInformations()
        self.monsters = []
        self.name = []
        self.name.append(self.main_monster.name)
        self.monsters_len = reader.readUnsignedShort()
        for i in range(0, self.monsters_len):
            self.monsters.append(MonsterInGroupInformations())
            self.name.append(self.monsters[-1].name)

class GroupMonsterStaticInformationsWithAlternatives(GroupMonsterStaticInformations):
    def __init__(self):
        super().__init__()
        self.alternatives_len = reader.readUnsignedShort()
        self.alternatives = []
        for i in range(0, self.alternatives_len):
            self.alternatives.append(AlternativeMonstersInGroupLightInformations())
