import os
import json

class Options():
    def __init__(self):
        self.username = ""
        self.connection = ""
        self.server = ""
        self.multi = False
        self.looking_for = []
        self.tshark_path = None
        self.notification = "notification"
        self.available_windows = {}
        self.current_window = None
        data = None
        if os.path.isfile(os.path.expandvars(r'%LOCALAPPDATA%') + '/ChrisPS/config_chrisps.json'):
            with open(os.path.expandvars(r'%LOCALAPPDATA%') + '/ChrisPS/config_chrisps.json', 'r', encoding='utf8') as json_file:
                try:
                    data = json.load(json_file)
                except:
                    data = {}
        if data and 'username' in data:
            self.username = data['username']
        if data and 'multi' in data:
            self.multi = data['multi']
        if data and 'looking_for' in data:
            self.looking_for = data['looking_for']
        if data and 'notification' in data:
            self.notification = data['notification']
        if data and 'connection' in data:
            self.connection = data['connection']
        if data and 'tshark_path' in data:
            self.tshark_path = data['tshark_path']

    def set_window(self):
        if self.current_window != None:
            self.username = self.current_window['name']
        self.update_settings(self.username, self.multi)

    def update_connection_type(self):
        data = None
        with open(os.path.expandvars(r'%LOCALAPPDATA%') + '/ChrisPS/config_chrisps.json', 'r') as json_file:
            try:
                data = json.load(json_file)
            except:
                data = {}
        data['connection'] = options.connection
        with open(os.path.expandvars(r'%LOCALAPPDATA%') + '/ChrisPS/config_chrisps.json', 'w+') as json_file:
            json.dump(data, json_file)

    def update_tshark_path(self):
        data = None
        with open(os.path.expandvars(r'%LOCALAPPDATA%') + '/ChrisPS/config_chrisps.json', 'r') as json_file:
            try:
                data = json.load(json_file)
            except:
                data = {}
        data['tshark_path'] = options.tshark_path
        with open(os.path.expandvars(r'%LOCALAPPDATA%') + '/ChrisPS/config_chrisps.json', 'w+') as json_file:
            json.dump(data, json_file)

    def update_lf(self):
        data = None
        with open(os.path.expandvars(r'%LOCALAPPDATA%') + '/ChrisPS/config_chrisps.json', 'r') as json_file:
            try:
                data = json.load(json_file)
            except:
                data = {}
        data["looking_for"] = self.looking_for
        with open(os.path.expandvars(r'%LOCALAPPDATA%') + '/ChrisPS/config_chrisps.json', 'w+') as json_file:
            json.dump(data, json_file)

    def update_notif(self):
        data = None
        with open(os.path.expandvars(r'%LOCALAPPDATA%') + '/ChrisPS/config_chrisps.json', 'r') as json_file:
            try:
                data = json.load(json_file)
            except:
                data = {}
        data["notification"] = self.notification
        with open(os.path.expandvars(r'%LOCALAPPDATA%') + '/ChrisPS/config_chrisps.json', 'w+') as json_file:
            json.dump(data, json_file)


    def update_settings(self, uname, multi):
        data = None
        with open(os.path.expandvars(r'%LOCALAPPDATA%') + '/ChrisPS/config_chrisps.json', 'r') as json_file:
            try:
                data = json.load(json_file)
            except:
                data = {}
        self.username = uname[:20]
        self.multi = multi
        for k, f in self.available_windows.items():
            if uname == f['name']:
                self.current_window = f
        data["username"] = self.username
        data["multi"] = self.multi
        data["looking_for"] = self.looking_for
        with open(os.path.expandvars(r'%LOCALAPPDATA%') + '/ChrisPS/config_chrisps.json', 'w+') as json_file:
            json.dump(data, json_file)

options = Options()
