from Reader import reader, types, status
from Log import LOG
from Gui import GUI
from pickler import decompress_pickle
from i18n import i18n_fr
import os
import requests
from Options import options
from Server import server

class ServerReference():
    def __init__(self):
        self.data = decompress_pickle(f'{os.path.dirname(__file__)}/data/Servers.pbz2')
    def find_by_id(self, idv):
        idv = int(idv)
        for item in self.data:
            if idv == int(item['id']):
                return item
        return None

serv_ref = ServerReference()

class BasicWhoIs():
    def __init__(self):
        box = reader.readByte()
        self.me = False if box & 1 == 0 else True
        if self.me is True:
            self.position = reader.readByte()
            self.account_nickname = reader.readString()
            self.account_id = reader.readInt()
            self.player_name = reader.readString()
            self.player_id = reader.readVarUhLong()
            self.area_id = reader.readShort()
            self.server_id = reader.readShort()
            self.server_name = i18n_fr.get_name(serv_ref.find_by_id(self.server_id)['nameId'])
            self.origin_server_id = reader.readShort()
        length = reader.readUnsignedShort()
        #Unfinished

class Player():
    def __init__(self, server):
        self.server_connect = server
        self.server = None
        self.server_id = None
        self.user_id = None
        self.infos_saved = False
        self.username = None
        self.authorized_updater = False

    def send_to_server(self):
        if self.infos_saved == False:
            if self.user_id is not None and self.username is not None:
                self.infos_saved = True
                if self.server_id is not None:
                    data = {
                        'server_id': self.server_id,
                        'username': self.username
                    }
            self.server_connect.send_to_server(data, "new_player/", server_req=False)
