from Reader import reader, types, status
from Log import LOG
from Gui import GUI
import Alliance
import ObjectItem

class PrismInformation():
    def __init__(self):
        self.type_id = reader.readByte()
        self.state = reader.readByte()
        self.vulnerability_date = reader.readInt()
        self.placement_date = reader.readInt()
        self.reward_count = reader.readVarUhShort()

class AllianceInsiderPrismInformation(PrismInformation):
    def __init__(self):
        super().__init__()
        self.last_modif_date = reader.readInt()
        self.last_modif_author_guild_id = reader.readVarUhInt()
        self.last_modif_author = reader.readVarUhLong()
        self.last_modif_author_name = reader.readString()
        self.items_len = reader.readUnsignedShort()
        self.items = []
        for i in range(0, self.items_len):
            self.items.append(ObjectItem.ObjectItem())

class AlliancePrismInformation(PrismInformation):
    def __init__(self):
        super().__init__()
        self.alliance = Alliance.AllianceInformations()