from Reader import reader, types, status
from Log import LOG
from Gui import GUI
import Actor
import Human
import Monster
import Guild
import TaxCollector
import Prism
import Portal

class GameRolePlayNpcQuestFlag():
    def __init__(self):
        self.to_valid = []
        self.to_start = []
        self.to_valid_len = reader.readUnsignedShort()
        for i in range(0, self.to_valid_len):
            self.to_valid.append(reader.readVarUhShort())
        self.to_valid_len = reader.readUnsignedShort()
        for i in range(0, self.to_valid_len):
            self.to_start.append(reader.readVarUhShort())

class GameRolePlayActorInformations(Actor.ContextActor):
    def __init__(self):
        self.id = -1
        super().__init__()
        return

class GameRolePlayNamedActorInformations(GameRolePlayActorInformations):
    def __init__(self):
        super().__init__()
        self.name = reader.readString()
        return

class GameRolePlayTreasureHintInformations(GameRolePlayActorInformations):
    def __init__(self):
        super().__init__()
        self.id = reader.readVarUhShort()

class GameRolePlayNpcInformations(GameRolePlayActorInformations):
    def __init__(self):
        super().__init__()
        self.id = reader.readVarUhShort()
        self.sex = reader.readBoolean()
        self.artwork = reader.readVarUhShort()

class GameRolePlayNpcWithQuestInformations(GameRolePlayNpcInformations):
    def __init__(self):
        super().__init__()
        self.quest_flag = GameRolePlayNpcQuestFlag()

class GameRolePlayMerchantInformations(GameRolePlayNamedActorInformations):
    def __init__(self):
        super().__init__()
        self.sell_type = reader.readByte()
        self.options_len = reader.readUnsignedShort()
        self.options = []
        for i in range(0, self.options_len):
            typev = reader.readType()
            if typev == "HumanOption;":
                self.options.append(Human.HumanOption())
            elif typev == "HumanOptionObjectUse;":
                self.options.append(Human.HumanOptionObjectUse())
            elif typev == "HumanOptionAlliance;":
                self.options.append(Human.HumanOptionAlliance())
            elif typev == "HumanOptionGuild;":
                self.options.append(Human.HumanOptionGuild())
            elif typev == "HumanOptionOrnament;":
                self.options.append(Human.HumanOptionOrnament())
            elif typev == "HumanOptionEmote;":
                self.options.append(Human.HumanOptionEmote())
            elif typev == "HumanOptionTitle;":
                self.options.append(Human.HumanOptionTitle())
            elif typev == "HumanOptionSkillUse;":
                self.options.append(Human.HumanOptionSkillUse())
            elif typev == "HumanOptionFollowers;":
                self.options.append(Human.HumanOptionFollowers())
            else:
                LOG.error(f"Unhandled type {typev} for GameRolePlayMerchantInformations")

class GameRolePlayMountInformations(GameRolePlayNamedActorInformations):
    def __init__(self):
        super().__init__()
        self.owner = reader.readString()
        self.level = reader.readUnsignedByte()

class GameRolePlayPrismInformations(GameRolePlayActorInformations):
    def __init__(self):
        super().__init__()
        typev = reader.readType()
        if typev == "PrismInformation;":
            self.prism = Prism.PrismInformation()
        elif typev == "AlliancePrismInformation;":
            self.prism = Prism.AlliancePrismInformation()
        elif typev == "AllianceInsiderPrismInformation;":
            self.prism = Prism.AllianceInsiderPrismInformation()
        else:
            LOG.error(f"Unhandled type {typev} for GameRolePlayPrismInformations")

class GameRolePlayTaxCollectorInformations(GameRolePlayActorInformations):
    def __init__(self):
        super().__init__()
        typev = reader.readType()
        if typev == "TaxCollectorStaticInformations;":
            self.identification = TaxCollector.TaxCollectorStaticInformations()
        elif typev == "TaxCollectorStaticExtendedInformations;":
            self.identification = TaxCollector.TaxCollectorStaticExtendedInformations()
        else:
            LOG.error(f"Unhandled type {typev} for GameRolePlayTaxCollectorInformations")
        self.guild_level = reader.readUnsignedByte()
        self.tax_collector_attack = reader.readInt()

class GameRolePlayGroupMonsterInformations(GameRolePlayActorInformations):
    def __init__(self):
        super().__init__()
        self.boxed_info_0 = reader.readByte()
        typev = reader.readType()
        if typev == "GroupMonsterStaticInformations;":
            self.static_infos = Monster.GroupMonsterStaticInformations()
            self.name = self.static_infos.name
        elif typev == "GroupMonsterStaticInformationsWithAlternatives;":
            self.static_infos = Monster.GroupMonsterStaticInformationsWithAlternatives()
            self.name = self.static_infos.name
        else:
            LOG.error(f"Unhandled type {typev} for GameRolePlayGroupMonsterInformations")
        self.loot_share = reader.readByte()
        self.alignment_side = reader.readByte()

class GameRolePlayPortalInformations(GameRolePlayActorInformations):
    def __init__(self):
        super().__init__()
        typev = reader.readType()
        if typev != "PortalInformation;":
            LOG.error(f"Unhandled type {typev} for GameRolePlayPortalInformations")
        self.portal = Portal.PortalInformation()


class GameRolePlayGroupMonsterWaveInformations(GameRolePlayGroupMonsterInformations):
    def __init__(self):
        self.name = ""
        super().__init__()
        self.nb_wave = reader.readByte()
        self.alternative_len = reader.readUnsignedShort()
        self.monsters_alternatives = []
        for i in range(0, self.alternative_len):
            typev = reader.readType()
            if typev == "GroupMonsterStaticInformations;":
                self.monsters_alternatives.append(Monster.GroupMonsterStaticInformations())
            elif typev == "GroupMonsterStaticInformationsWithAlternatives;":
                self.monsters_alternatives = (Monster.GroupMonsterStaticInformationsWithAlternatives())
            else:
                LOG.error(f"Unhandled type {typev} for GameRolePlayGroupMonsterWaveInformations")

class GameRolePlayHumanoidInformations(GameRolePlayNamedActorInformations):
    def __init__(self):
        super().__init__()
        human_type = reader.readType()
        if human_type == "HumanInformations;":
            self.human = Human.HumanInformations()
        else:
            LOG.error(f"Unhandled type {human_type} for GameRolePlayHumanoidInformations")
        self.account_id = reader.readInt()

class GameRolePlayCharacterInformations(GameRolePlayHumanoidInformations):
    def __init__(self):
        super().__init__()
        self.alignment = Actor.ActorAlignmentInformations()

class GameRoleplayMutantInformations(GameRolePlayHumanoidInformations):
    def __init__(self):
        self.name = ""
        super().__init__()
        self.monster_id = reader.readVarUhShort()
        self.power_level = reader.readByte()