from Log import LOG
import requests
import threading

class Server():
    def __init__(self):
        self.player = None

    def update_player(self, player):
        self.player = player

    def send_to_server(self, data, route, server_req=True, user_id=None, username=None):
        if self.player.server is None and server_req is True:
            LOG.error("No server set, use /whoami.")
            return
        if username == None:
            username = self.player.username
        if user_id == None:
            user_id = self.player.user_id
        data['server'] = self.player.server
        data['server_id'] = self.player.server_id
        data['user_id'] = user_id
        data['username'] = username
        serv = threading.Thread(target=threaded_send_to_server, args=(data, route, ))
        serv.start()

    def ask_server(self, data, route):
        ret = requests.post(f'https://chrisps.captain-nwa.ch/{route}', json=data)
        return ret
server = Server()

def threaded_send_to_server(data, route):
    ret = requests.post(f"https://chrisps.captain-nwa.ch/{route}", json=data)
    return ret
