from Reader import reader
from spell_list import spells_list

refer_type = ["Neutre", "Terre", "Feu", "Eau", "Air", "Multi-Element"]

class Spell():
    def __init__(self):
        self.damage = []
        return

    def parse_attack(self):
        self.noise = reader.readByte()
        self.target_id = reader.readDouble()
        self.destination_cell = reader.readShort()
        self.critical = reader.readByte()
        self.spell_name = "Melee"
        return self

    def parse_spell(self):
        self.noise = reader.readByte()
        self.target_id = reader.readDouble()
        self.destination_cell = reader.readShort()
        self.critical = reader.readByte()
        self.spell_id = reader.readVarUhShort()
        self.spell_name = str(spells_list[str(self.spell_id)] if str(self.spell_id) in spells_list else self.spell_id)
        self.spell_level = reader.readShort()
        return self

    def parse_damage(self, shield=False):
        damages = {}
        damages['target_id'] = reader.readDouble()
        damages['loss'] = reader.readVarUhInt()
        damages['perm_loss'] = reader.readVarUhInt()
        damages['element_id'] = reader.readVarInt()
        try:
            damages['element_name'] = refer_type[damages['element_id']]
        except:
            damages['element_name'] = damages['element_id']
        if shield == True:
            damages['loss'] += reader.readVarUhShort()
        self.damage.append(damages)
        return