import os
import json
from pickler import decompress_pickle


class SpellLevelReference():
    def __init__(self):
        self.data = decompress_pickle(f'{os.path.dirname(__file__)}/data/SpellLevels.pbz2')

    def get_spell_level_by_id(self, idv):
        idv = int(idv)
        for item in self.data:
            if idv == item['id']:
                return item
        return None

    def get_spell_level_and_effect_by_effect_uid(self, uid):
        uid = int(uid)
        for item in self.data:
            for effect in item['effects']:
                if effect['effectUid'] == uid:
                    return item, effect
            for crit in item['criticalEffect']:
                if crit['effectUid'] == uid:
                    return item, crit
        return None, None

spell_levels_reference = SpellLevelReference()