html = """
<!DOCTYPE html>
<html>
<head>
    <style>
        body {
  overflow: hidden;
}

.main {
  background-color: #1D1E22;
  color: white;
  position: fixed;
  padding: 0;
  margin: 0;
  padding-top:1px;
  z-index: -1;
  top: 65px;
  left: 0;
  width: 400px;
  height: 250px;
  font-family: "Tahoma";
  padding-bottom: 2px;
  border-bottom: 1px solid lightgray;
  border-right: 1px solid lightgray;
  border-left: 1px solid lightgray;
}

.overbar {
  height: 23px;
  padding: 0;
  margin: 0.3px;
  width: 100%;
  display: inline-block;
  vertical-align: center;
}

input[type=checkbox] {
  background-color: black;
}

.spell_overbar {
  height: 23px;
  padding: 0;
  margin: 0.3px;
  width: 100%;
  display: inline-block;
  vertical-align: center;
}

.menu_bar {
  grid-row: 3;
  bottom: 0px;
  top: 7px;
  width: 100%;
  left: 0;
  border-bottom: 2px solid rgb(59, 49, 49);
  grid-column: 1 /span 10;
  display:grid;
  grid-template-columns: auto 15% 15% 15% 15% 15% 15% auto;
  grid-template-rows: 100%;
}

.menu_item {
  cursor: pointer;
  background-color: rgb(59, 49, 49);
  border-top: 1px solid white;
  border-left: 1px solid white;
  border-right: 1px solid white;
  border-bottom: 0;
  height:100%;
  border-top-right-radius: 3px;
  border-top-left-radius: 3px;
  font-size:10pt;
  width: 100%;
}

#combat_item {
  grid-column: 3;
  grid-row: 1;
}

#overview_item {
  grid-column: 4;
  grid-row: 1;
}

#fm_item {
  grid-column: 5;
  grid-row: 1;
}

#hunt_item {
  grid-column: 6;
  grid-row: 1;
}

.view_log {
  grid-column: 2;
  grid-row: 1;
}

.advanced_log {
  grid-column: 3;
  grid-row: 1;
}

.dump_log {
  grid-column: 4;
  grid-row: 1;
}

button:disabled,
button[disabled]{
  border: 1px solid #999999;
  background-color: #cccccc;
  color: #666666;
}

.menu_item:hover {
  opacity: 0.8;
}

.selected {
  background-color: rgb(17, 14, 14);
  border-top: 1px solid white;
  border-left: 1px solid white;
  border-right: 1px solid white;
}

.overview_container {
  height: 100%;
  width: 100%;
  display: grid;
  grid-template-columns: auto 32% 16% 16% 32% auto;
  grid-template-rows: auto 12% 12% 15% 15% 15% 15% 15% auto;
}

.player_name_display {
  grid-column: 2 / span 4;
  grid-row: 2;
  text-align: center;
  font-size: 22pt;
}

.player_portrait {
  width: 100%;
  height: 100%;
  grid-column: 2;
  grid-row: 3 / 8;
  background-color: grey;
}

.points_display_left {
  grid-column: 3;
  grid-row: 3;
  background-color: blue;
  font-size: 16pt;
  text-align: center;
}

.points_display_right {
  grid-column: 4;
  grid-row: 3;
  background-color: green;
  font-size: 16pt;
  text-align: center;
}

.infos_display_player {
  grid-column: 3 / 5;
  grid-row: 4 / 8;
  text-align: center;
  margin: 5px;
}

.buff_display {
  grid-column: 5;
  grid-row: 3 / 8;
  margin: 3px;
}

input[type=number] {
  -moz-appearance: textfield;
  appearance: textfield;
  margin: 0;
}

.hideme {
  display: none;
}

.woo {
  position: relative;
  top: 4px;
  cursor: pointer;
}

.hideme + .woo:before {
  width: 10px;
  height: 10px;
  border: 2px solid gray;
  box-shadow: -1px 1px 2px 2px rgba(0,0,0,0.2);
  background: black;
  position: relative;
  display: inline-block;
  margin-right: 1ex;
  content: "";
}

.hideme:checked + .woo:before {
  background: lightgreen;
}

#multi-option {
  font-size: 18pt;
  grid-row: 4;
  grid-column: 3;
  align-self: center;
  text-align: center;
}

.view_select {
  display:block;
  height: 25px;
  width: 100%;
  padding-left: 20%;
  padding-right: 20%;
}

.view_item:hover {
  opacity: 0.8;
}

.view_item {
  cursor:pointer;
  background-color: rgb(43, 40, 40);
  overflow:hidden;
  border-top: 1.5px solid rgb(14, 12, 12);
  border-bottom: 1.5px solid rgb(14, 12, 12);
  border-left: 0.75px solid rgb(14, 12, 12);
  border-right: 0.75px solid rgb(14, 12, 12);
  -webkit-appearance:button;
  -moz-appearance:button;
  display: inline-block;
  width: 12%;
  margin-top: 2px;
  text-align: center;
  font-size: 10pt;
  margin-bottom: 2px
}
.arrow_container {
  position:absolute;
  bottom: 15px;
  left: 5px;
  width: 25px;
  height: 25px;
  border: 2px solid rgb(14, 12, 12);
  background-color: rgb(43, 40, 40);
  border-radius: 4px;
  box-shadow: -1px -1px 0 1px rgb(14, 12, 12) inset;
  -webkit-box-shadow: -2px -2px rgb(14, 12, 12) inset;
}
.arrow {
  position:relative;
  cursor: pointer;
  left: -20px;
  bottom: 7px;
  background-color: transparent;
  padding: 25%; /* Arrow size */
  box-shadow: 1px -1px 0 1px plum inset;
  -webkit-box-shadow: 2px -2px plum inset;
  -moz-box-shadow: 2px -2px plum inset;
  border: solid transparent;
  border-width: 0 0 2rem 2rem;
  transition: 0.2s;
}

.arrow:hover {
          box-shadow: 2px -2px 0 2px orchid inset;
  -webkit-box-shadow: 4px -4px orchid inset;
}

.arrow-up    { transform:rotate(135deg) }
.arrow-right { transform:rotate(225deg) }
.arrow-down  { transform:rotate(-45deg) }
.arrow-left  { transform:rotate(45deg) }

.tooltip {
  position: relative;
  display: inline-block;
}
/* Tooltip text */
.tooltip .tooltiptext {
  visibility: hidden;
  width: 100%;
  background-color: black;
  color: #fff;
  text-align: center;
  padding: 5px 0;
  border-radius: 6px;

  width: 120px;
  bottom: 100%;
  left: 50%;
  margin-left: -60px; /* Use half of the width (120/2 = 60), to center the tooltip */
  position: absolute;
  z-index: 1;
}

.box {
  width: 40%;
  margin: 0 auto;
  background: rgba(255,255,255,0.2);
  padding: 35px;
  border: 2px solid #fff;
  border-radius: 20px/50px;
  background-clip: padding-box;
  text-align: center;
}

.button {
  font-size: 1em;
  padding: 10px;
  color: #fff;
  border: 2px solid #06D85F;
  border-radius: 20px/50px;
  text-decoration: none;
  cursor: pointer;
  transition: all 0.3s ease-out;
}
.button:hover {
  background: #06D85F;
}

.search_main {
  text-shadow: -1px -1px 0 #000, 1px -1px 0 #000, -1px 1px 0 #000, 1px 1px 0 #000;
  width: 100%;
  height: 90%;
  display:grid;
  grid-template-columns: 49% 49%;
  grid-template-rows: 90%;
  letter-spacing: 1px;
}
.name_finder {
  width: 90%;
  left: 5px;
  position:relative;
  background-color: black;
  font-size: 9pt;
  margin-bottom: 5px;
}
.searched_div {
  overflow-y: auto;
  overflow-x: hidden;
  grid-column-start: 1;
  grid-row-start: 1;
  border-right: 2px solid white;
}

.available_search {
  overflow-y: auto;
  overflow-x: hidden;
  grid-column-start: 2;
  grid-row-start: 1;
}

.searched_item {
  cursor: pointer;
  overflow: hidden;
  font-size: 11pt;
  width: 90%;
  display:inline-block;
  height: 15px;
  left: 5px;
  position: relative;
  border: 1px solid rgb(128, 103, 241);
  background-color: rgb(140, 140, 228);
  border-radius: 3px;
}
#missing {
  display: none;
}
.searched_item:hover {
  opacity: 0.8
}

.available {
  border: 1px solid rgb(131, 241, 103);
  background-color: rgb(162, 218, 99)
}

.modal {
  display: none; /* Hidden by default */
  position: absolute; /* Stay in place */
  z-index: 999; /* Sit on top */
  left: 0;
  top: 0;
  width: 100%; /* Full width */
  height: 100%; /* Full height */
  overflow: none; /* Enable scroll if needed */
  width: 400px;
  height: 310px;
  background-color: rgb(0,0,0); /* Fallback color */
  background-color: rgba(0,0,0,0.4); /* Black w/ opacity */
}

/* Modal Content/Box */
.modal-content {
  border: 1px solid rgb(235, 218, 218);
  background-color: #3f3d3d;
  margin: 15% auto; /* 15% from the top and centered */
  padding: 20px;
  font-size: 15pt;
  border: 1px solid #888;
  width: 80%; /* Could be more or less, depending on screen size */
  height: 50%;
}

/* The Close Button */
.close {
  color: #aaa;
  float: right;
  font-size: 28px;
  font-weight: bold;
}

.close:hover,
.close:focus {
  color: black;
  text-decoration: none;
  cursor: pointer;
}
/* Show the tooltip text when you mouse over the tooltip container */
.tooltip:hover .tooltiptext {
  visibility: visible;
}

.option {
  float: right;
}

.overbar:hover {
  cursor: pointer;
  opacity:0.8;
}
.namebar {
    margin-top: 2px;
    height: 23px;
    width: 400px;
    font-family: "Bebas Neue";
    font-size: 11pt;
}
.align-right {
  letter-spacing: 1px;
  margin: 0;
  display: inline-block;
  width:45%;
  font-size: 11pt;
  right: 10px;
  text-align: right;
}
.align-left {
  letter-spacing: 1px;
  margin: 0;
  display: inline-block;
  left: 0;
  width:49%;
  font-size: 11pt;
  text-align: left;
}
.bar {
  text-shadow: -1px -1px 0 #000, 1px -1px 0 #000, -1px 1px 0 #000, 1px 1px 0 #000;
  -moz-border-radius: 2px;
  -webkit-border-radius: 2px;
  -moz-border-radius: 2px;
  border-radius: 2px;
  padding: 0;
  padding-left: 3px;
  padding-top: 1px;
  height: 100%;
  background-color: rgb(70, 70, 70);
  background-image: linear-gradient(
    center bottom,
    rgb(43,194,83) 37%,
    rgb(84,240,84) 69%
  );
  display: block;
  box-shadow:
    inset 0 2px 9px  rgba(255,255,255,0.3),
    inset 0 -2px 6px rgba(0,0,0,0.4);
}

.elem-1 {
  background-color: #503014;
}

.elem-2 {
  background-color: red;
}

.elem-3 {
  background-color: #18BCF6;
}

.elem-4 {
  background-color: green;
}

.elem-multi {
  background-color: rgb(107, 7, 107);
}

.header {
  display: grid;
  grid-template-rows: 20% 50% 30%;
  grid-template-columns: 18% 18% 18% 18% 18% 10%;
  text-align:center;
  background-color:black;
  color:white;
  height: 70px;
  width:400px;
  left:0;
  top:0;
  padding:0;
  margin:0;
  position:fixed;
  border-top: 1px solid lightgray;
  border-right: 1px solid lightgray;
  border-left: 1px solid lightgray;
}

.popup_closer {
  display: none;
  position: absolute;
  width: 400px;
  height:320px;
  z-index: 10;
  top: 0;
  left: 0;
  z-index: 19;
}

.popup {
  width: 80%;
  display: block;
  border: 1px solid rgb(182, 179, 179);
  background: rgb(179, 171, 171);
  border-radius: 1px;
  height: 80%;
  margin: 10%;
  z-index: 20;
}

.header_select_name {
  grid-row: 2;
  grid-column: 1 / span 2;
  margin: auto;
  padding: 2px;
  border: 1px solid lightgrey;
  background-color: darkslategrey;
  border-radius: 1px;
  cursor: pointer;
}

.header_buttons {
  grid-row: 1;
  grid-column: 1 / span 10;
  display: grid;
  grid-template-rows: 100%;
  grid-template-columns: auto 8% 8% 8%;
  cursor: pointer;
}

.header_min_button {
  grid-column: 3;
  grid-row: 1;
}

.header_min_button:hover {
  background-color:yellow;
}

.header_log_button {
  grid-column: 2;
  grid-row: 1;
}

.header_log_button:hover {
  background-color: green;
}

.header_exit_button {
  grid-column: 4;
  grid-row: 1;
}

.header_exit_button:hover {
  background-color:red;
}

.header_title {
  grid-row: 2;
  grid-column: 2 / span 3;
  font-size:17pt;
  margin: auto;
}


.hunt_container {
  border: 2px solid black;
  background-color: rgb(82, 82, 82);
  position: relative;
  display: block;
  margin-top: 25px;
  margin-left: 5px;
  width: 80%;
  height: 80%;
  left: 8%;
}

.arrowhunt_container {
  left: 30%;
  display: block;
  position:relative;
  width: 40%;
  height: 70%;
}

.infohunt_container {
  text-align: center;
  font-size: 18px;
  display: block;
  position:relative;
}

.arrowhunt {
  position: relative;
  display: inline-block;
  margin: 30px;
  padding: 40px;
  box-shadow: 15px -15px 0 0 rgb(255, 255, 255) inset;
}

.arrowhunt--left {
  transform: rotate(45deg);
}
.arrowhunt--right {
  transform: rotate(225deg);
}
.arrowhunt--top {
  transform: rotate(135deg);
}
.arrowhunt--bottom {
  transform: rotate(-45deg);
  bottom: 20px;
}

.checkmark {
  display:inline-block;
  width: 22px;
  height:22px;
  -ms-transform: rotate(45deg); /* IE 9 */
  -webkit-transform: rotate(45deg); /* Chrome, Safari, Opera */
  -moz-transform: rotate(45deg); /* Chrome, Safari, Opera */
  transform: rotate(45deg);
}

.checkmark_stem {
  position: absolute;
  width:30px;
  height:90px;
  background-color:rgb(65, 168, 5);
  left: 85px;
  top: -51px;
}

.checkmark_kick {
  position: absolute;
  width:30px;
  height:30px;
  background-color:rgb(65, 168, 5);
  left: 56px;
  top: 9px;
}
.fm_container {
  display: grid;
  grid-template-rows: 5% 30% 25% 30% 10%;
  grid-template-columns: 10% 40% 40% 10%;
  height: 90%;
  width: 100%;
}
.fm_item_infos {
  display: block;
  height: 80%;
  width: 99%;
  grid-column: 2;
  grid-row: 2;
  border: 1px solid black;
  background-color: #5E5E5E;
  -webkit-box-shadow: 0px 1px 0px 1px rgba(0,0,0,0.36);
  -moz-box-shadow: 0px 1px 0px 1px rgba(0,0,0,0.36);
  box-shadow: 0px 1px 0px 1px rgba(0,0,0,0.36);
  font-size: 15pt;
  text-align:center;
  padding-top: 9%;
}
.fm_rune_infos {
  display: block;
  height: 80%;
  width: 100%;
  grid-column: 3;
  grid-row: 2;
  border: 1px solid black;
  background-color: #5E5E5E;
  -webkit-box-shadow: 1px 1px 0px 1px rgba(0,0,0,0.36);
  -moz-box-shadow: 1px 1px 0px 1px rgba(0,0,0,0.36);
  box-shadow: 1px 1px 0px 1px rgba(0,0,0,0.36);
  font-size: 15pt;
  text-align:center;
  padding-top: 9%;
}
.fm_pool_infos {
  display: inline-block;
  height: 100%;
  width: 100%;
  grid-row: 3;
  grid-column: 2 / span 2;
  text-align:center;
}
.fm_pool_input {
  display: inline-block;
  position: relative;
  width: 30%;
  height: 40%;
  top: 30%;
  bottom: 30%;
  background-color: transparent;
  font-size: 11pt;
  text-align:center;
}
.fm_text_infos {
  display: block;
  position:relative;
  height: 100%;
  width: 100%;
  grid-row: 4;
  grid-column: 2 / span 2;
  padding: 5%;
  font-size: 12pt;
}

.overflow {
  overflow-y: scroll;
  overflow-x: hidden;
  display: flex;
  border: 0;
  flex-direction: column-reverse;
}

.whatever{
  display: inline-block;
  width: 120px;
  height: 15%;
  margin: 2.5%;
  padding: 3%;
  border: 1px solid black;
  text-align:center;
  cursor: pointer;
  text-shadow: -1px 0 black, 0 1px black, 1px 0 black, 0 -1px black;
}

.all_char {
  width: 280px;
}

#combat_main {
  margin-top: 15px;
}

#combat_player_main {
  margin-top: 15px;
}

.whatever:hover {
  background-color: rgba(255,255,255,0.5);
}

#checkboxes input[type=checkbox]{
  display: none;
}

#checkboxes input[type=checkbox]:checked + .whatever{
  border: 1px solid rgb(27, 233, 27);
  color: rgb(27, 233, 27);
  background-color: darkslategrey;
}
* {
  color: white;
  font-family: 'Bebas Neue';
  font-size:9pt;
}

@font-face {
  font-family: 'Bebas Neue';
  src: url(https://fonts.gstatic.com/s/bebasneue/v1/JTUSjIg69CK48gW7PXoo9Wlhyw.woff2) format('woff2');
}

.monster {
  background-color: rgb(70, 70, 70);
}

.eliotrope {
  background-color: rgb(0, 128, 128);
}

.huppermage {
  background-color: rgb(230, 190, 255);
}

.ouginak {
  background-color: rgb(170, 110, 40);
}

.steamer {
  background-color: rgb(255, 255, 255);
}

.roublard {
  background-color: rgb(128, 128, 128);
}

.zobal {
  background-color: rgb(230, 25, 75);
}

.pandawa {
  background-color: rgb(128, 0, 0);
}

.sram {
  background-color: rgb(145, 30, 180);
}

.enutrof {
  background-color: rgb(255, 250, 200);
}

.xelor {
  background-color: rgb(0, 130, 200);
}

.osamodas {
  background-color: rgb(0, 0, 128);
}

.sacrieur {
  background-color: rgb(170, 255, 195);
}

.sadida {
  background-color: rgb(60, 180, 75);
}

.feca {
  background-color: rgb(255, 225, 25);
}

.cra {
  background-color: rgb(210, 245, 60);
}

.iop {
  background-color: rgb(245, 130, 48);
}

.ecaflip {
  background-color: rgb(70, 240, 240);
}

.eniripsa {
  background-color: rgb(240, 50, 230);
}
    </style>
    <script>
window.addEventListener('pywebviewready', function() {
  pywebview.api.on_pywebview_ready();
})
var data = "";

function update_header() {
  pywebview.api.get_header().then(function(response) {
    document.getElementById('head').innerHTML = response;
  });
}

function update_main() {
  pywebview.api.get_body().then(function(response) {
    document.getElementById('main').innerHTML = response;
  });
}

var current = ""
function select_user(name) {
  current = "user"
  var items = document.getElementsByName('rGroup');
  for (var i = 0; i < items.length; i ++) {
      items[i].checked = false;
  }
  document.getElementById(name).checked = true;
  document.getElementById('header_name_display_info').innerHTML = name;
  pywebview.api.update_settings_player(name);
}

function minimize_window() {
  pywebview.api.minimize_window();
}

function exit_window() {
  pywebview.api.exit_window()
}

function select_all_users() {
  current = "all"
  var items = document.getElementsByName('rGroup');
  for (var i = 0; i < items.length; i ++) {
      items[i].checked = true;
  }
  document.getElementById('header_name_display_info').innerHTML = "Multi";
  pywebview.api.update_settings_multi(true);
}

function popup_name_appear()
{
  document.getElementsByClassName('popup')[0].addEventListener('click', function(e) {
    e.preventDefault();
    e.stopPropagation();
  });
  promise = pywebview.api.update_popup('name').then(function(response) {
    document.getElementsByClassName('popup')[0].innerHTML = response;
    if (current == "all") {
      var items = document.getElementsByName('rGroup');
      for (var i = 0; i < items.length; i ++) {
          items[i].checked = true;
    }
  }
  });
  document.getElementsByClassName('popup_closer')[0].style.display = 'block';
}

function close_popup() {
  document.getElementsByClassName('popup_closer')[0].style.display = 'none';
}

function set_view_combat() {
  pywebview.api.set_view_combat();
}

function set_view_overview() {
  pywebview.api.set_view_overview();
}

function set_view_fm() {
  pywebview.api.set_view_fm();
}

function set_view_hunt() {
  pywebview.api.set_view_hunt();
}

function update_fm_pool_value() {
  var value = document.getElementById("fm_pool_current_value").value
  pywebview.api.update_fm_pool(value)
}
function update_content(response) {
  document.body.innerHTML = response;
}

function set_combat_player_view(player_name) {
  pywebview.api.set_view_combat_player(player_name)
}
    </script>
</head>
<body <!--class="pywebview-drag-region"-->>
<div class="header" id="head">

</div>
<div class="main" id="main">

</div>
</body>
</html>
"""