import bz2
import pickle
import json
import _pickle as cPickle

# Pickle a file and then compress it into a file with extension 
def compressed_pickle(title, data):
    with bz2.BZ2File('data/' + title + '.pbz2', 'w') as f: 
        cPickle.dump(data, f)

def decompress_pickle(file):
    data = bz2.BZ2File(file, 'rb')
    data = cPickle.load(data)
    return data


if __name__ == "__main__":
    val = [
        'data/i18n_fr.json',
        'data/Areas.json',
        'data/Challenge.json',
        'data/Characteristics.json',
        'data/Effects.json',
        'data/Houses.json',
        'data/Items.json',
        'data/MapPositions.json',
        'data/Monsters.json',
        'data/PointOfInterest.json',
        'data/Servers.json',
        'data/SpellLevels.json',
        'data/Spells.json',
        'data/SubAreas.json',
        'data/SuperAreas.json',
    ]
    for value in val:
        try:
            with open(value, 'r') as f:
                name = value.split('/')[-1].split('.')[0]
                compressed_pickle(name, json.load(f))
        except:
            print (f"Missing file {value}")