import sys

from os import system, name

from time import sleep
import struct

def pretty_print(clas, indent=0):
    print(' ' * indent +  type(clas).__name__ +  ':')
    indent += 4
    for k,v in clas.__dict__.items():
        if isinstance(v, list):
            for item in v:
                if '__dict__' in dir(item):
                    pretty_print(item,indent)
                else:
                    print(' ' * indent + str(item))
        elif '__dict__' in dir(v):
            pretty_print(v,indent)
        else:
            print(' ' * indent +  k + ': ' + str(v))

def clear():
    if name == 'nt':
        _ = system('cls')
    else:
        _ = system('clear')

def read_int(value):
    value = 0
    offset = 0
    has_next = 0
    chunk_size = 7
    int_size = 32
    current = ""
    byte_offset = 0
    while offset < int_size:
        current = value[byte_offset:byte_offset+2]
        byte_offset += 2
        has_next = (int(current, 16) >> 7)
        if offset > 0:
            value += ((int(current, 16) & 0b01111111) << offset)
        else:
            value += int(current, 16) & 0b01111111
        offset += chunk_size
        if has_next == 0:
            return value

def read_short(value):
    value = 0
    offset = 0
    has_next = 0
    chunk_size = 7
    int_size = 16
    current = ""
    byte_offset = 0
    while offset < int_size:
        current = value[byte_offset:byte_offset+2]
        byte_offset += 2
        has_next = (int(current, 16) >> 7)
        if offset > 0:
            value += ((int(current, 16) & 0b01111111) << offset)
        else:
            value += int(current, 16) & 0b01111111
        offset += chunk_size
        if has_next == 0:
            return value

def offset_int(value):
    value = 0
    offset = 0
    has_next = 0
    chunk_size = 7
    int_size = 32
    current = ""
    byte_offset = 0
    while offset < int_size:
        current = value[byte_offset:byte_offset+2]
        byte_offset += 2
        has_next = (int(current, 16) >> 7)
        if offset > 0:
            value += ((int(current, 16) & 0b01111111) << offset)
        else:
            value += int(current, 16) & 0b01111111
        offset += chunk_size
        if has_next == 0:
            return byte_offset

def hexa_dump(value):
    i = 0
    line = 0
    ret = ''
    ret_str = ''
    total_len = len(value)
    for i in range(0, total_len):
        val = struct.unpack(">B", value[i:i+1])[0]
        if line == 16:
            print(ret, end=" | ")
            print(ret_str)
            ret = ''
            ret_str = ''
            line = 0
        ret += (str(hex(val)).split('0x')[1].zfill(2)) + " "
        if chr(val).isprintable():
            ret_str += chr(val)
        else:
            ret_str += '.'
        line += 1
    print(f"{ret:<48}", end=" | ")
    print(ret_str)


if __name__ == "__main__":
    print (read_int(sys.argv[1]))
    # print (hexa_dump(sys.argv[1].replace(' ', '')))
