from setuptools import setup
from ChrisPS.__version__ import __version__

WEB_FILES = [
    'web/base.html',
    'web/option.html',
    'web/search.html',
    'web/view.html',
    'web/combat_footer.html',
    'web/script.js',
    'web/webview.css',
    'web/BebasNeue-Regular.ttf',
    'web/fm.html'
]

DATA_FILES = [
    'data/i18n_fr.pbz2',
    'data/Items.pbz2',
    'data/MapPositions.pbz2',
    'data/Effects.pbz2',
    'data/Monsters.pbz2',
    'data/PointOfInterest.pbz2',
    'data/Challenge.pbz2',
    'data/Characteristics.pbz2',
    'data/MapPositions.pbz2',
    'data/Spells.pbz2',
    'data/SpellLevels.pbz2'
]

setup(
    name='ChrisPS',
    version=__version__,
    description='ChrisPS is the best',
    author='Captain Nwach',
    author_email='devnull@chrisps.captain-nwa.ch',
    install_requires=[],
    packages=['ChrisPS', 'ChrisPS/web', 'ChrisPS/sounds'],
    package_data={'': WEB_FILES + DATA_FILES + ['sounds/notification.mp3', 'sounds/link_beatbox.mp3']},
    include_package_data=True,
    entry_points={
        'console_scripts': [
            'chrisps = ChrisPS.chrisps:main',
        ]
    }
)
